<?php
   /**
    *
    * copyright (c) 2015-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * Classe per gestire le traduzioni del proprio progetto. Consente sia di trovare una traduzione nella linuga 
    * desiderata che di modificare i file delle traduzioni.
    * I file devono essere in formato json, contengono delle coppie nome valore che rappresentano la stringa da tradurre 
    * e la sua traduzione. 
    */

    class GestoreTraduzioni {
        private $cartellaTraduzioni;
        PRIVATE $lingue;
        private $traduzioni;
        
        public function __construct($cartellaTraduzioni,$lingue) {
            $this->cartellaTraduzioni = $cartellaTraduzioni;
            $this->lingue     = $lingue;
            $this->traduzioni = array();
        }
        
        /*
         * aggiorna l'array delle traduzioni leggendo dai file delle lingue interessate
         */
        function caricaTraduzioni() {
            foreach($this->lingue as $lingua) {
                $datiLingua = json_decode(file_get_contents($this->cartellaTraduzioni."/".$lingua.".json"),true);
                $this->traduzioni[$lingua] = $datiLingua;
            }
        }
        
        /*
         * restituisce la traduzione della stringa passata in input nella lingua richiesta
         * se non è presente viene restituito un messaggio di errore
         */
        function traduci($stringa,$lingua) {
            if(in_array($lingua, array_keys($this->traduzioni))) {
                $datiLinugaRichiesta = $this->traduzioni[$lingua];
                if(isset($datiLinugaRichiesta[$stringa])) {
                    return $datiLinugaRichiesta[$stringa];
                }
                else {
                    return "Stringa non trovata: $stringa";
                }
            }
            else {
                return "Lingua non trovata: $lingua";
            }
        }
        
        /*
         * Metodo per salvare il file della lingua specificata
         * richiede un array contenente le stringhe da tradurre e la traduzione
         */
        function modificaFileTraduzione($lingua,$traduzioni) {
            if(count($traduzioni)>0) {
                $fileTraduzioni = fopen($this->cartellaTraduzioni."/$lingua.json","w");
                fwrite($fileTraduzioni, json_encode($traduzioni));
                fclose($fileTraduzioni);
            }
            else {
                echo "Gestore traduzioni: si sta tentando di aggiornare un file di traduzione con un array vuoto";
                exit();
            }
        }
        
        // getter & setter
        public function getCartellaTraduzioni() {
            return $this->cartellaTraduzioni;
        }

        public function getLingue() {
            return $this->lingue;
        }
        
        public function getTraduzioni() {
            return $this->traduzioni;
        }

        public function setCartellaTraduzioni($cartellaTraduzioni): void {
            $this->cartellaTraduzioni = $cartellaTraduzioni;
        }

        public function setLingue($lingue): void {
            $this->lingue = $lingue;
        }
        
        public function setTraduzioni($traduzioni): void {
            $this->traduzioni = $traduzioni;
        }

    }